{*
* 2017 Azelab
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@areama.net so we can send you a copy immediately.
*
*
*  @author Azelab <support@azelab.com>
*  @copyright  2017 Azelab
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of Azelab
*}
<style>
    #arcontactus-config-tabs{
        opacity: 0;
        transition: 0.2s all;
    }
    #arcontactus-config-tabs.active{
        opacity: 1;
    }
    #arcontactus-config .form-group .form-group{
        margin-bottom: 0;
    }
    #arcontactus-config .form-group .form-group .color{
        margin-left: 5px;
    }
    #arcu-schedule-group .cbx{
        margin-bottom: 0;
        margin-right: 10px;
        margin-top: 7px;
    }
</style>
<div class="row" id="arcontactus-config">
    <div class="col-lg-2 col-md-3">
        <div class="list-group arcontactusTabs">
            <a class="list-group-item {if empty($active_tab) or $active_tab == 'ArContactUsGeneralConfig'}active{/if}" data-tab="0" id="arcontactus-tab-0" data-target="arcontactus-general" href="#">
                <i class="icon-cog"></i> {l s='General configuration' mod='arcontactus'}
            </a>
            <a class="list-group-item {if $active_tab == 'ArContactUsButtonConfig'}active{/if}" data-tab="1" id="arcontactus-tab-1" data-target="arcontactus-button" href="#">
                <i class="icon-cog"></i> {l s='Button settings' mod='arcontactus'}
            </a>
            <a class="list-group-item {if $active_tab == 'ArContactUsMenuConfig' || $active_tab == 'ArContactUsMenuMobileConfig'}active{/if}" data-tab="2" id="arcontactus-tab-2" data-target="arcontactus-menu" href="#">
                <i class="icon-cog"></i> {l s='Menu settings' mod='arcontactus'}
            </a>
            <a class="list-group-item {if $active_tab == 'ArContactUsCallbackConfig'}active{/if}" data-tab="3" id="arcontactus-tab-3" data-target="arcontactus-callback" href="#">
                <i class="icon-cog"></i> {l s='Callback popup settings' mod='arcontactus'}
            </a>
            <a class="list-group-item {if $active_tab == 'ArContactUsLiveChatConfig'}active{/if}" data-tab="2" data-target="arcontactus-livechat" href="#">
                <i class="icon-cog"></i> {l s='Live chat integrations' mod='arcontactus'}
            </a>
            <a class="list-group-item {if $active_tab == 'ArContactUsPromptConfig'}active{/if}" data-tab="4" id="arcontactus-tab-4" data-target="arcontactus-prompt" href="#">
                <i class="icon-cog"></i> {l s='Prompt settings' mod='arcontactus'}
            </a>
            <a class="list-group-item" data-tab="4" id="arcontactus-tab-4" data-target="arcontactus-prompt-items" href="#">
                <i class="icon-cog"></i> {l s='Prompt messages' mod='arcontactus'}
            </a>
            <a class="list-group-item" data-tab="4" id="arcontactus-tab-4" data-target="arcontactus-items" href="#">
                <i class="icon-cog"></i> {l s='Menu items' mod='arcontactus'}
            </a>
            <a class="list-group-item" data-tab="5" id="arcontactus-tab-5" data-target="arcontactus-callbacks" href="#">
                <i class="icon-cog"></i> {l s='Callback requests' mod='arcontactus'}
            </a>
            <a class="list-group-item" data-tab="10" id="arcontactus-tab-10" data-target="arcontactus-about" href="#">
                <i class="icon-info"></i> {l s='About' mod='arcontactus'}
            </a>
        </div>
    </div>
    <div class="col-lg-10 col-md-9" id="arcontactus-config-tabs">
        {include file="./_partials/_general.tpl"}
        {include file="./_partials/_button.tpl"}
        {include file="./_partials/_menu.tpl"}
        {include file="./_partials/_livechat.tpl"}
        {include file="./_partials/_callback.tpl"}
        {include file="./_partials/_prompt.tpl"}
        {include file="./_partials/_prompt_items.tpl"}
        {include file="./_partials/_items.tpl"}
        {include file="./_partials/_callbacks.tpl"}
        {include file="./_partials/_about.tpl"}
    </div>
</div>

<script type="text/javascript">
    window.addEventListener('load', function(){
        arCU.ajaxUrl = '{$link->getAdminLink('AdminArContactUs') nofilter}'; {* URL generated by Link object, no escape necessary. Escaping will break functionality *}
        arCU.prompt.ajaxUrl = '{$link->getAdminLink('AdminArContactUsPrompt') nofilter}'; {* URL generated by Link object, no escape necessary. Escaping will break functionality *}
        arCU.addTitle = "{l s='Add new item' mod='arcontactus'}";
        arCU.editTitle = "{l s='Edit item' mod='arcontactus'}";
        arCU.successSaveMessage = "{l s='Item saved' mod='arcontactus'}";
        arCU.successOrderMessage = "{l s='Order updated' mod='arcontactus'}";
        arCU.successDeleteMessage = "{l s='Item deleted' mod='arcontactus'}";
        arCU.errorMessage = "{l s='Error has occured' mod='arcontactus'}";
        $(".arcontactusTabs a").click(function(e){
            e.preventDefault();
            $(".arcontactusTabs .active").removeClass('active');
            $(this).addClass('active');
            if ($(this).data('target') == 'arcontactus-callbacks') {
                arCU.callback.reload();
            }
            $('#arcontactus-config .arcontactus-config-panel').addClass('hidden');
            $('#' + $(this).data('target')).removeClass('hidden');
            $('#arcontactusActiveTab').remove();
            $('#arcontactusActiveTab').val($(this).data('tab'));
        });
        $('.arcontactusTabs .active').trigger('click');
        arContactUsSwitchFields();
        $('.prestashop-switch').click(function(){
            arContactUsSwitchFields();
        });
        {if !$onesignalInstalled}
            $('#arcontactus-callback .field_onesignal').remove();
        {/if}
        $('#arcontactus-config-tabs').addClass('active');
        arCU.init();
        $('.time-mask').mask('XX:XX:XX');
        var currentTime = '{$currentTime|escape:'htmlall':'UTF-8'}';
        var currentMoment = moment(currentTime, 'kk:mm:ss');
        setInterval(function(){
            $('#server-time').text(currentMoment.add(1, 'seconds').format('kk:mm:ss'));
        }, 1000);
    });
    
    function arContactUsSwitchFields(){
        if ($('#ARCUC_EMAIL_on').is(':checked')){
            $('.field_email_list').removeClass('hidden');
        }else{
            $('.field_email_list').addClass('hidden');
        }
        
        if ($('#ARCUC_RECAPTCHA_on').is(':checked')){
            $('.field_key, .field_secret').removeClass('hidden');
        }else{
            $('.field_key, .field_secret').addClass('hidden');
        }
        
        if ($('#ARCUC_TWILIO_on').is(':checked')){
            $('.field_twilio_api_key, .field_twilio_auth_token, .field_twilio_phone, .field_twilio_tophone, .field_twilio_message').removeClass('hidden');
        }else{
            $('.field_twilio_api_key, .field_twilio_auth_token, .field_twilio_phone, .field_twilio_tophone, .field_twilio_message').addClass('hidden');
        }
        
        if ($('#ARCUPR_LOOP_on').is(':checked')){
            $('.field_close_last').addClass('hidden');
        }else{
            $('.field_close_last').removeClass('hidden');
        }
        
        if ($('#ARCUC_PHONE_MASK_ON_on').is(':checked')){
            $('.field_phone_mask').removeClass('hidden');
        }else{
            $('.field_phone_mask').addClass('hidden');
        }
        
        if ($('#ARCUL_TAWK_TO_ON_on').is(':checked')){
            $('.field_tawk_to_site_id, .field_tawk_to_widget, .field_tawk_to_userinfo').removeClass('hidden');
        }else{
            $('.field_tawk_to_site_id, .field_tawk_to_widget, .field_tawk_to_userinfo').addClass('hidden');
        }
        
        if ($('#ARCUL_CRISP_ON_on').is(':checked')){
            $('.field_crisp_site_id').removeClass('hidden');
        }else{
            $('.field_crisp_site_id').addClass('hidden');
        }
        
        if ($('#ARCUL_INTERCOM_ON_on').is(':checked')){
            $('.field_intercom_app_id').removeClass('hidden');
        }else{
            $('.field_intercom_app_id').addClass('hidden');
        }
        
        if ($('#ARCUL_FB_ON_on').is(':checked')){
            $('.field_fb_page_id, .field_fb_init, .field_fb_lang, .field_fb_color').removeClass('hidden');
        }else{
            $('.field_fb_page_id, .field_fb_init, .field_fb_lang, .field_fb_color').addClass('hidden');
        }
        
        if ($('#ARCUL_VK_ON_on').is(':checked')){
            $('.field_vk_page_id').removeClass('hidden');
        }else{
            $('.field_vk_page_id').addClass('hidden');
        }
        
        if ($('#ARCUL_ZOPIM_ON_on').is(':checked')){
            $('.field_zopim_id, .field_zopim_userinfo').removeClass('hidden');
        }else{
            $('.field_zopim_id, .field_zopim_userinfo').addClass('hidden');
        }
        
        if ($('#ARCUL_SKYPE_ON_on').is(':checked')){
            $('.field_skype_type, .field_skype_id, .field_skype_message_color').removeClass('hidden');
        }else{
            $('.field_skype_type, .field_skype_id, .field_skype_message_color').addClass('hidden');
        }
        
        if ($('#ARCUL_ZALO_ON_on').is(':checked')){
            $('.field_zalo_id, .field_zalo_welcome, .field_zalo_width, .field_zalo_height').removeClass('hidden');
        }else{
            $('.field_zalo_id, .field_zalo_welcome, .field_zalo_width, .field_zalo_height').addClass('hidden');
        }
        
        if ($('#ARCUL_LHC_ON_on').is(':checked')){
            $('.field_lhc_uri, .field_lhc_width, .field_lhc_height, .field_lhc_popup_width, .field_lhc_popup_height').removeClass('hidden');
        }else{
            $('.field_lhc_uri, .field_lhc_width, .field_lhc_height, .field_lhc_popup_width, .field_lhc_popup_height').addClass('hidden');
        }
        
        if ($('#ARCUL_SS_ON_on').is(':checked')){
            $('.field_ss_key, .field_ss_userinfo').removeClass('hidden');
        }else{
            $('.field_ss_key, .field_ss_userinfo').addClass('hidden');
        }
        
        if ($('#ARCUL_LC_ON_on').is(':checked')){
            $('.field_lc_key, .field_lc_userinfo').removeClass('hidden');
        }else{
            $('.field_lc_key, .field_lc_userinfo').addClass('hidden');
        }
        
        if ($('#ARCUL_TIDIO_ON_on').is(':checked')){
            $('.field_tidio_key, .field_tidio_userinfo').removeClass('hidden');
        }else{
            $('.field_tidio_key, .field_tidio_userinfo').addClass('hidden');
        }
        
        if ($('#ARCUL_LCP_ON_on').is(':checked')){
            $('.field_lcp_uri').removeClass('hidden');
        }else{
            $('.field_lcp_uri').addClass('hidden');
        }
        
        if ($('#ARCUL_LZ_ON_on').is(':checked')){
            $('.field_lz_id').removeClass('hidden');
        }else{
            $('.field_lz_id').addClass('hidden');
        }
        
        if ($('#ARCUC_GDPR_on').is(':checked')){
            $('.field_gdpr_title').removeClass('hidden');
        }else{
            $('.field_gdpr_title').addClass('hidden');
        }
        
        if ($('#ARCUM_MENU_HEADER_ON_on').is(':checked')){
            $('#arcu-menu-desktop .field_menu_header, #arcu-menu-desktop .field_header_close, #arcu-menu-desktop .field_header_close_bg, #arcu-menu-desktop .field_header_close_color').removeClass('hidden');
        }else{
            $('#arcu-menu-desktop .field_menu_header, #arcu-menu-desktop .field_header_close, #arcu-menu-desktop .field_header_close_bg, #arcu-menu-desktop .field_header_close_color').addClass('hidden');
        }
        
        if ($('#ARCUMM_MENU_HEADER_ON_on').is(':checked')){
            $('#arcu-menu-mobile .field_menu_header, #arcu-menu-mobile .field_header_close, #arcu-menu-mobile .field_header_close_bg, #arcu-menu-mobile .field_header_close_color').removeClass('hidden');
        }else{
            $('#arcu-menu-mobile .field_menu_header, #arcu-menu-mobile .field_header_close, #arcu-menu-mobile .field_header_close_bg, #arcu-menu-mobile .field_header_close_color').addClass('hidden');
        }
        
        if ($('#ARCU_SANDBOX_on').is(':checked')){
            $('.field_allowed_ips').removeClass('hidden');
        }else{
            $('.field_allowed_ips').addClass('hidden');
        }
        
        if ($('#ARCU_ALWAYS_on').is(':checked')){
            $('#arcu-schedule-group').addClass('hidden');
            $('#arcontactus_always').val(1);
        }else{
            $('#arcu-schedule-group').removeClass('hidden');
            $('#arcontactus_always').val(0);
        }
        
        if ($('#ARCU_product_page_on').is(':checked')){
            $('#arcontactus_product_page').val(1);
        }else{
            $('#arcontactus_product_page').val(0);
        }
    }
</script>