<?php
/**
* 2007-2020 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@buy-addons.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    Buy-Addons <contact@buy-addons.com>
*  @copyright 2007-2020 PrestaShop SA
*  @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
* @since 1.6
*/

class BASmartSeoAltTagsAltsManage extends BASmartSeoAltTags
{
    public $helperlist_id = 'BASmartSeoAltTagsAltsManage';
    public $language_list;
    public function __construct()
    {
        $languages = Language::getLanguages(false);
        if (!empty($languages)) {
            foreach ($languages as $l) {
                $this->language_list[$l['id_lang']] = $l['name'];
            }
        }
        parent::__construct();
    }
    public function process($params = array())
    {
        $params;
        if (Tools::isSubmit('submitBulkdeleteBASmartSeoAltTagsAltsManage')) {
            $this->bulkDeleteAltText();
        }
        if (Tools::isSubmit('deleteBASmartSeoAltTagsAltsManage')) {
            $this->deleteAltText();
        }
        if (Tools::isSubmit('savealt') || Tools::isSubmit('savealtandstay')) {
            return $this->saveAltText();
        }
        if (Tools::isSubmit('updateBASmartSeoAltTagsAltsManage')) {
            $form = $this->displayForm();
            if ($form != false) {
                return $form;
            }
        }
        $this->resetHelperList();
        $this->setCookieFilter();
        return $this->renderHelperList();
    }
    public function saveAltText()
    {
        $legend = Tools::getValue("legend");
        $id_image = (int) Tools::getValue("id_image");
        $id_lang = (int) Tools::getValue("id_lang");
        $otherlanguage = (int) Tools::getValue("otherlanguage");
        $db = Db::getInstance();
        // update an Alt text
        $sql = 'UPDATE `'._DB_PREFIX_.'image_lang`';
        $sql .= ' SET legend = "'.pSQL($legend).'" ';
        $sql .= ' WHERE id_lang = '.(int) $id_lang;
        $sql .= ' AND id_image = '.(int) $id_image;
        $db->query($sql);
        // update for all
        if ($otherlanguage == 1) {
            $sql = 'UPDATE `'._DB_PREFIX_.'image_lang`';
            $sql .= ' SET legend = "'.pSQL($legend).'" ';
            $sql .= ' WHERE id_image = '.(int) $id_image;
            $db->query($sql);
        }
        $this->smarty->assign('success', $this->l('Successful update'));
        if (Tools::isSubmit('savealt')) {
            return $this->renderHelperList();
        } else {
            $key_image = Tools::getValue("key_image");
            return $this->displayForm($key_image);
        }
        return true;
    }
    public function displayForm($key_image = null)
    {
        if ($key_image === null) {
            $key_image = Tools::getValue("key_image");
        }
        $arr = explode("-", $key_image);
        $id_product = (int) $arr[0];
        $id_lang = (int) @$arr[1];
        $id_image = (int) @$arr[2];
        if (empty($id_image) || empty($id_lang)) {
            $this->smarty->assign('error', $this->l('This product have not yet any images. Please add an image.'));
            return false;
        }
        // get infor of this image
        $db = Db::getInstance();
        $sql = 'SELECT * FROM `'._DB_PREFIX_.'image` AS i';
        $sql .= ' INNER JOIN `'._DB_PREFIX_.'image_lang` AS il ON i.id_image = il.id_image ';
        $sql .= ' WHERE i.id_image = '.(int) $id_image;
        $items = $db->ExecuteS($sql);
        if (empty($items)) {
            $this->smarty->assign('error', $this->l('Image does not exist.'));
            return false;
        }
        $languages = Language::getLanguages(false);
        $languages_l = array();
        foreach ($languages as $l) {
            $languages_l[$l['id_lang']] = $l['name'].' ('.$l['iso_code'].')';
        }
        // display Alt Text of other languages
        $items_l = array();
        $other_l = array();
        foreach ($items as $item) {
            $id_l = $item['id_lang'];
            $items_l[$id_l] = $item['legend'];
            if ($id_l != $id_lang) {
                $other_l[$id_l] = $languages_l[$id_l].': '.$item['legend'];
            }
        }
        // get Product Info
        $p_link = 'index.php?controller=AdminProducts';
        $p_link .='&token='.Tools::getAdminTokenLite('AdminProducts');
        $p_link .='&id_product='.$id_product;
        $p_link .='&updateproduct&key_tab=Images&action=Images';
        // product name
        $id_shop = (int) $this->context->shop->id;
        $id_admin_lang = (int) $this->context->language->id;
        $sql = 'SELECT name FROM `'._DB_PREFIX_.'product_lang` AS pl';
        $sql .= ' WHERE pl.id_shop = '.(int) $id_shop;
        $sql .= ' AND pl.id_lang = '.(int) $id_admin_lang;
        $product_name = $db->getValue($sql);
        $this->smarty->assign('items', $items);
        $this->smarty->assign('languages', $languages);
        $this->smarty->assign('item', $items_l);
        $this->smarty->assign('others', $other_l);
        $this->smarty->assign('current_lang', $languages_l[$id_lang]);
        $this->smarty->assign('id_lang', $id_lang);
        $this->smarty->assign('id_image', $id_image);
        $this->smarty->assign('key_image', $key_image);
        $this->smarty->assign('id_product', $id_product);
        $this->smarty->assign('product_name', $product_name);
        $this->smarty->assign('p_link', $p_link);
        return $this->shortDisplay('views/templates/admin/editform.tpl');
    }
    public function bulkDeleteAltText()
    {
        $key_arr = Tools::getValue("BASmartSeoAltTagsAltsManageBox");
        if (empty($key_arr)) {
            $this->smarty->assign('success', $this->l('Successful delete.'));
            return false;
        }
        foreach ($key_arr as $key_image) {
            $arr = explode("-", $key_image);
            $id_lang = (int) @$arr[1];
            $id_image = (int) @$arr[2];
            $db = Db::getInstance();
            $sql = 'UPDATE `'._DB_PREFIX_.'image_lang`';
            $sql .= ' SET legend = "" ';
            $sql .= ' WHERE id_lang = '.(int) $id_lang;
            $sql .= ' AND id_image = '.(int) $id_image;
            $db->query($sql);
        }
        $this->smarty->assign('success', $this->l('Successful delete.'));
        return true;
    }
    public function deleteAltText()
    {
        $key_image = Tools::getValue("key_image");
        $arr = explode("-", $key_image);
        $id_lang = (int) @$arr[1];
        $id_image = (int) @$arr[2];
        if (empty($id_image) || empty($id_lang)) {
            $this->smarty->assign('error', $this->l('This product have not yet any images. Please add an image.'));
            return false;
        }
        $db = Db::getInstance();
        $sql = 'UPDATE `'._DB_PREFIX_.'image_lang`';
        $sql .= ' SET legend = "" ';
        $sql .= ' WHERE id_lang = '.(int) $id_lang;
        $sql .= ' AND id_image = '.(int) $id_image;
        $db->query($sql);
        $this->smarty->assign('success', $this->l('Successful delete.'));
        return true;
    }
    public function renderHelperList()
    {
        $token = Tools::getAdminTokenLite('AdminModules');
        $helper = new HelperList();
        $helper->shopLinkType = '';
        $helper->simple_header = false;
        $helper->actions = array('edit', 'delete');
        $helper->identifier = 'key_image';
        $helper->toolbar_btn['back'] = array(
            'href' => AdminController::$currentIndex . '&configure=' . $this->name
            .'&batask=customkey&token=' . $token,
            'desc' => $this->l('Refresh')
        );
        $helper->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected'),
                'icon' => 'icon-trash',
                'confirm' => $this->l('Delete selected items?')
            )
        );
        $helper->show_toolbar = true;
        $helper->no_link = true;
        $helper->title = $this->l('Alt Tag Management');
        $helper->table = $this->helperlist_id;
        $helper->list_id = $this->helperlist_id;
        $helper->token = $token;
        $helper->imageType = 'jpg';
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name.'&batask=altsmanage';
        $orderby = $this->context->cookie->{$helper->list_id.'Orderby'};
        $orderway = $this->context->cookie->{$helper->list_id.'Orderway'};
        $helper->orderBy = $orderby;
        $helper->orderWay = Tools::strtoupper($orderway);
        
        $fields_list = array(
            'id_image' => array(
                'title' => $this->l('#ID'),
                'width' => '30',
                'type' => 'text',
                'align' => 'left key_image',
            ),
            'image' => array(
                'title' => $this->l('Image'),
                'filter_key' => 'id_image',
                'width' => '50',
                'type' => 'text',
                'image' => 'p',
                'align' => 'center',
                'orderby' => false,
                'search' => false,
            ),
            'id_lang' => array(
                'title' => $this->l('Language'),
                'type' => 'select',
                'list' => $this->language_list,
                'filter_key' => 'id_lang',
                'callback' => 'displayLanguage',
                'callback_object' => $this,
                'width' => '100',
                'align' => 'left'
            ),
            'legend' => array(
                'title' => $this->l('Alt Text'),
                'type' => 'text',
                'align' => 'left'
            ),
            'id_product' => array(
                'title' => $this->l('#ID Product'),
                'type' => 'text',
                'width' => 30,
                'align' => 'left',
                'callback' => 'displayIDProduct',
                'callback_object' => $this,
            ),
            'name' => array(
                'title' => $this->l('Product Name'),
                'type' => 'text',
                'align' => 'left',
                'callback' => 'displayProduct',
                'callback_object' => $this,
            ),
            'cover' => array(
                'title' => $this->l('Cover'),
                'type' => 'bool',
                'width' => 30,
                'align' => 'left',
                'callback' => 'displayCover',
                'callback_object' => $this,
            ),
            'position' => array(
                'title' => $this->l('Position'),
                'type' => 'text',
                'width' => 30,
                'align' => 'right'
            ),
        );
        $helper->listTotal = $this->getTotalData();
        $rows = $this->getHelperListData();

        $this->helperlist_template = $helper->generateList($rows, $fields_list);
        $tab = $this->shortDisplay('views/templates/admin/tab.tpl');
        return $tab.$this->helperlist_template;
    }
    
    public function getHelperListData()
    {
        $db = Db::getInstance();
        $sql = "SELECT pl.id_product, pl.name, pl.link_rewrite, img.id_image ";
        $sql .= ",img.position,img.cover, img_l.legend, pl.id_lang ";
        $sql .= ",CONCAT_WS('', pl.id_product, '-', pl.id_lang, '-', img.id_image) as key_image";
        $sql .= ' FROM '._DB_PREFIX_.'product_lang AS pl ';
        $sql .= ' LEFT JOIN (';
        $sql .= _DB_PREFIX_.'image AS img INNER JOIN '._DB_PREFIX_.'image_shop AS img_s ON img.id_image=img_s.id_image';
        $sql .= ' INNER JOIN '._DB_PREFIX_.'image_lang AS img_l ON img.id_image=img_l.id_image ';
        $sql .= ' ) ON pl.id_product = img.id_product AND pl.id_lang = img_l.id_lang';
        $sql .= " WHERE ".$this->getWhereClause();
        
        $orderby = $this->context->cookie->{$this->helperlist_id.'Orderby'};
        $orderway = $this->context->cookie->{$this->helperlist_id.'Orderway'};
        if (!empty($orderby) && !empty($orderby)) {
            $sql.=' ORDER BY '.pSQL($orderby).' '.pSQL($orderway);
        }
        // Pagination
        $item_per_page = $this->context->cookie->{$this->helperlist_id.'_pagination'};
        $start = $this->context->cookie->{$this->helperlist_id.'_start'};
        $sql.= ' LIMIT '.(int) $start.', '.(int) $item_per_page;
        $results = $db->ExecuteS($sql);
        return $results;
    }
    public function getTotalData()
    {
        $db = Db::getInstance();
        $sql = "SELECT count(*)";
        $sql .= ' FROM '._DB_PREFIX_.'product_lang AS pl ';
        $sql .= ' LEFT JOIN (';
        $sql .= _DB_PREFIX_.'image AS img INNER JOIN '._DB_PREFIX_.'image_shop AS img_s ON img.id_image=img_s.id_image';
        $sql .= ' INNER JOIN '._DB_PREFIX_.'image_lang AS img_l ON img.id_image=img_l.id_image ';
        $sql .= ' ) ON pl.id_product = img.id_product AND pl.id_lang = img_l.id_lang';
        $sql .= " WHERE ".$this->getWhereClause();
        $count = $db->getValue($sql);
        return $count;
    }
    public function getWhereClause()
    {
        $id_shop = (int) Context::getContext()->shop->id;
        $where = array("pl.id_shop = ".$id_shop);
        $where[] = "(img_s.id_shop = ".$id_shop . ' OR img_s.id_shop is NULL)';
        
        $id_image = (int) $this->context->cookie->{$this->helperlist_id.'Filter_id_image'};
        if (!empty($id_image)) {
            $where[] = "img.id_image LIKE '%".(int) $id_image."%'";
        }
        $id_lang = (int) $this->context->cookie->{$this->helperlist_id.'Filter_id_lang'};
        if ($id_lang != 0) {
            $where[] = "pl.id_lang LIKE '%".(int) $id_lang."%'";
        }
        $legend = $this->context->cookie->{$this->helperlist_id.'Filter_legend'};
        if (!empty($legend)) {
            $where[] = "img_l.legend LIKE '%".pSQL($legend)."%'";
        }
        $id_product = (int) $this->context->cookie->{$this->helperlist_id.'Filter_id_product'};
        if (!empty($id_product)) {
            $where[] = "pl.id_product LIKE '%".(int) $id_product."%'";
        }
        $name = $this->context->cookie->{$this->helperlist_id.'Filter_name'};
        if (!empty($name)) {
            $where[] = "pl.name LIKE '%".pSQL($name)."%'";
        }
        $cover = $this->context->cookie->{$this->helperlist_id.'Filter_cover'};
        if ($cover !== "" && $cover !== false && $cover !== null) {
            $cover = (int) $cover;
            if ($cover == 1) {
                $where[] = "img_s.cover = 1";
            } else {
                $where[] = "(img_s.cover = 0 OR img_s.cover IS NULL)";
            }
        }
        $position = (int) $this->context->cookie->{$this->helperlist_id.'Filter_position'};
        if (!empty($position)) {
            $where[] = "img.position LIKE '%".pSQL($position)."%'";
        }
        return implode(" AND ", $where);
    }
    public function setCookieFilter()
    {
        /// Filter
        if (Tools::getValue($this->helperlist_id . "Filter_id_image", null) !== null) {
            $i = pSQL(Tools::getValue($this->helperlist_id.'Filter_id_image'));
            $this->context->cookie->{$this->helperlist_id.'Filter_id_image'} = $i;
        }
        if (Tools::getValue($this->helperlist_id . "Filter_id_lang", null) !== null) {
            $i = pSQL(Tools::getValue($this->helperlist_id.'Filter_id_lang'));
            $this->context->cookie->{$this->helperlist_id.'Filter_id_lang'} = $i;
        }
        if (Tools::getValue($this->helperlist_id . "Filter_legend", null) !== null) {
            $l = pSQL(Tools::getValue($this->helperlist_id.'Filter_legend'));
            $this->context->cookie->{$this->helperlist_id.'Filter_legend'} = $l;
        }
        if (Tools::getValue($this->helperlist_id . "Filter_id_product", null) !== null) {
            $i = pSQL(Tools::getValue($this->helperlist_id.'Filter_id_product'));
            $this->context->cookie->{$this->helperlist_id.'Filter_id_product'} = $i;
        }
        if (Tools::getValue($this->helperlist_id . "Filter_name", null) !== null) {
            $n = pSQL(Tools::getValue($this->helperlist_id.'Filter_name'));
            $this->context->cookie->{$this->helperlist_id.'Filter_name'} = $n;
        }
        $cover = Tools::getValue($this->helperlist_id . "Filter_cover", null);
        if ($cover !== null) {
            $c = Tools::getValue($this->helperlist_id.'Filter_cover');
            $this->context->cookie->{$this->helperlist_id.'Filter_cover'} = $c;
        }
        if (Tools::getValue($this->helperlist_id . "Filter_position", null) !== null) {
            $p = pSQL(Tools::getValue($this->helperlist_id.'Filter_position'));
            $this->context->cookie->{$this->helperlist_id.'Filter_position'} = $p;
        }
        //////// Sort by
        if (Tools::getValue($this->helperlist_id . "Orderby", '') != '') {
            $o = pSQL(Tools::getValue($this->helperlist_id . "Orderby"));
            $this->context->cookie->{$this->helperlist_id.'Orderby'} = $o;
        }
        if (empty($this->context->cookie->{$this->helperlist_id.'Orderby'})) {
            $this->context->cookie->{$this->helperlist_id.'Orderby'} = 'id_product';
        }
        if (Tools::getValue($this->helperlist_id . "Orderway", '') != '') {
            $o = pSQL(Tools::getValue($this->helperlist_id . "Orderway"));
            $this->context->cookie->{$this->helperlist_id.'Orderway'} = $o;
        }
        if (empty($this->context->cookie->{$this->helperlist_id.'Orderway'})) {
            $this->context->cookie->{$this->helperlist_id.'Orderway'} = 'asc';
        }
        //pagination
        $item_per_page=$this->context->cookie->{$this->helperlist_id.'_pagination'};
        $item_per_page=(int) Tools::getValue($this->helperlist_id.'_pagination', $item_per_page);
        if ($item_per_page <=0) {
            $item_per_page = 20;
        }
        $this->context->cookie->{$this->helperlist_id.'_pagination'} = $item_per_page; // get Selected Page number
        // page_number
        $page = (int) Tools::getValue('submitFilter'.$this->helperlist_id);
        if (!$page) {
            $page = 1;
        }
        $start = ($page -1 )* $item_per_page;
        $this->context->cookie->{$this->helperlist_id.'_start'} = ($start <0) ? 0 : $start;
        return true;
    }
    public function resetHelperList()
    {
        if (Tools::isSubmit('submitResetBASmartSeoAltTagsAltsManage')) {
            $this->context->cookie->{$this->helperlist_id.'Filter_id_image'} = null;
            $this->context->cookie->{$this->helperlist_id.'Filter_id_lang'} = null;
            $this->context->cookie->{$this->helperlist_id.'Filter_legend'} = null;
            $this->context->cookie->{$this->helperlist_id.'Filter_id_product'} = null;
            $this->context->cookie->{$this->helperlist_id.'Filter_name'} = null;
            $this->context->cookie->{$this->helperlist_id.'Filter_cover'} = null;
            $this->context->cookie->{$this->helperlist_id.'Filter_position'} = null;
            $this->context->cookie->{$this->helperlist_id.'Orderby'} = 'id_product';
            $this->context->cookie->{$this->helperlist_id.'Orderway'} = 'asc';
            $admin_token = Tools::getAdminTokenLite('AdminModules');
            $url = AdminController::$currentIndex.'&configure='.$this->name.'&batask=altsmanage&token='.$admin_token;
            Tools::redirectAdmin($url);
            return true;
        }
        return false;
    }
    public function displayLanguage($value)
    {
        return $this->language_list[$value];
    }
    public function displayCover($value)
    {
        if ($value == 1) {
            return $this->l('Yes');
        }
        return '';
    }
    public function displayIDProduct($value, $row)
    {
        $value;
        $p_controller = 'index.php?controller=AdminProducts';
        $p_controller .='&token='.Tools::getAdminTokenLite('AdminProducts');
        $p_controller .='&id_product='.(int) $row['id_product'];
        $p_controller .='&updateproduct&key_tab=Images&action=Images';
        $link = '<a href="'.$p_controller.'" target="_blank">#'.$row['id_product'].'</a>';
        return $link;
    }
    public function displayProduct($value, $row)
    {
        $value;
        $p_controller = 'index.php?controller=AdminProducts';
        $p_controller .='&token='.Tools::getAdminTokenLite('AdminProducts');
        $p_controller .='&id_product='.(int) $row['id_product'];
        $p_controller .='&updateproduct&key_tab=Images&action=Images';
        $link = '<a href="'.$p_controller.'" target="_blank">'.$row['name'].'</a>';
        return $link;
    }
    public static function installNew()
    {
        return true;
    }
    public static function uninstallNew()
    {
        return true;
    }
}
