{*
* 2007-2020 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@buy-addons.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
* @author    Buy-addons    <contact@buy-addons.com>
* @copyright 2007-2020 Buy-addons
* @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
<div class="panel">
    <h3 class="panel-heading" rev="#filter-alt-setting-wrapper">
	<i class="icon-cogs"></i> {l s='Generate Alt Text for Filtered Products' mod='basmartseoalttags'}
	<span class="button-collapse"><i class="icon-collapse-alt"></i></span>
	</h3>
	<input type="hidden" name="batask" value="general" />
	<div id="filter-alt-setting-wrapper">
		<div class="form-group">
			<label class="control-label col-lg-3" for="alt_format">
				{l s='Alt Tags Format' mod='basmartseoalttags'}
			</label>
			<div class="col-lg-5">
				<div class="row translatable-field">
					<div class="col-lg-10">
						{foreach $languages item=language}
						{assign var="id_l" value=$language.id_lang}
						<input class="translatable-textfield language-{$id_l|escape:'htmlall':'UTF-8'}{if $id_l == $language_default->id} default-language{/if}" type="text" id="alt_format_{$id_l|escape:'htmlall':'UTF-8'}" name="alt_format[{$id_l|escape:'htmlall':'UTF-8'}]" value="{$alt_format->$id_l|escape:'htmlall':'UTF-8'}"/>
						{/foreach}
					</div>
					<div class="col-lg-2">
						<button type="button" class="btn btn-default dropdown-toggle language_view" data-toggle="dropdown" tabindex="-1" data-id-choose="{$language_default->id|escape:'htmlall':'UTF-8'}">
							{$language_default->iso_code|escape:'htmlall':'UTF-8'}
							<span class="caret"></span>
						</button>
						<ul class="dropdown-menu">
							{foreach $languages item=language}
								{assign var="id_l" value=$language.id_lang}
								{assign var="iso_code" value=$language.iso_code}
								<li>
									<a  href="javascript:void(0);" onclick="basmartseoalttags_hideOtherLanguage(this, '{$id_l|escape:'htmlall':'UTF-8'}','{$iso_code|escape:'htmlall':'UTF-8'}')">{$iso_code|escape:'htmlall':'UTF-8'}</a>
								</li>
							{/foreach}
						</ul>
					</div>
				</div>
				<div class="help-block">
				<strong>{l s='You can use some tokens of Product' mod='basmartseoalttags'}:</strong><br />
				{l s='[id]: ID of a Product' mod='basmartseoalttags'}. 
				<a class="more_tokens_click" href="javascript::void(0)" onclick="alttags_moretokens()">{l s='More' mod='basmartseoalttags'}</a>
				<div class="more_tokens_content">
				{l s='[name]: Name of a Product' mod='basmartseoalttags'}<br />
				{l s='[reference]: Reference of a Product' mod='basmartseoalttags'}<br />
				{l s='[ean13]: EAN-13 of a Product' mod='basmartseoalttags'}<br />
				{l s='[upc]: UPC of a Product' mod='basmartseoalttags'}<br />
				{l s='[position]: Position of image in a Product' mod='basmartseoalttags'}<br />
				{l s='[id_image]: ID of image in a Product' mod='basmartseoalttags'}<br />
				{l s='[main_category_name]: Main Category Name of a Product' mod='basmartseoalttags'}<br />
				{l s='[meta_title]: Meta title of a Product' mod='basmartseoalttags'}<br />
				{l s='[meta_description]: Meta description of a Product' mod='basmartseoalttags'}<br />
				{l s='[friendly_url]: Friendly URL of a Product' mod='basmartseoalttags'}<br />
				{l s='[brand]: Brand (Manufacturer) of a Product' mod='basmartseoalttags'}<br />
				{l s='[language]: Name of language for Alt Text, ex: English, Deutsch (German)' mod='basmartseoalttags'}<br />
				{l s='[wholesale_excl_tax]: Pre-tax wholesale price of a Product' mod='basmartseoalttags'}<br />
				{l s='[retail_excl_tax]: Pre-tax retail price of a Product' mod='basmartseoalttags'}<br />
				{l s='[retail_incl_tax]: Retail price with tax of a Product' mod='basmartseoalttags'}<br />
				{l s='[unit_price]: Unit price of a Product' mod='basmartseoalttags'}<br />
				{l s='[unit]: Unit of a Product' mod='basmartseoalttags'}<br />
				{l s='[price_before_discount]: Price before discount (include Tax) of a Product' mod='basmartseoalttags'}<br />
				{l s='[price_after_discount]: Price after discount (include Tax) of a Product' mod='basmartseoalttags'}<br />
				</div>
				</div>
			</div>
		</div>
		<div class="form-group">
			<label class="control-label col-lg-3" for="max_chars">
				{l s='Max Chars' mod='basmartseoalttags'}
			</label>
			<div class="col-lg-5">
				<input type="text" id="max_chars" name="max_chars" value="{$max_chars|escape:'htmlall':'UTF-8'}" />
				<div class="help-block">
				{l s='If the length of Alt Text is more than Max Chars, the Module will truncate it. Empty or set 0 for no limit' mod='basmartseoalttags'}
				</div>
			</div>
		</div>
		<div class="form-group">
			<label class="control-label col-lg-3">
				{l s='Replace Text for Languages' mod='basmartseoalttags'}
			</label>
			<div class="col-lg-5">
				<select name="languages[]" size="2" multiple>
					{foreach from=$languages item=lang}
						<option value="{$lang.id_lang|escape:'htmlall':'UTF-8'}"{if !empty($selected_languages) && in_array($lang.id_lang,$selected_languages)} selected{/if}>{$lang.name|escape:'htmlall':'UTF-8'}</option>
					{/foreach}
				</select>
			</div>
		</div>
		<div class="form-group">
			<label class="control-label col-lg-3">
				{l s='Only replace if currrent Alt Text is empty' mod='basmartseoalttags'}
			</label>
			<div class="col-lg-5">
				<span class="switch prestashop-switch fixed-width-lg">
					<input onclick="toggleDraftWarning(false);showOptions(true);showRedirectProductOptions(false);" type="radio" name="alt_empty" id="alt_empty_on" value="1"{if $alt_empty != 0} checked="checked"{/if} />
					<label for="alt_empty_on" class="radioCheck">
						{l s='Yes' mod='basmartseoalttags'}
					</label>
					<input onclick="toggleDraftWarning(true);showOptions(false);showRedirectProductOptions(true);" type="radio" name="alt_empty" id="alt_empty_off" value="0" {if $alt_empty == 0} checked="checked"{/if} />
					<label for="alt_empty_off" class="radioCheck">
						{l s='No' mod='basmartseoalttags'}
					</label>
					<a class="slide-button btn"></a>
				</span>
				<div class="help-block">
				<strong>{l s='For an example' mod='basmartseoalttags'}</strong>:<br />
				{l s='An image has 3 ALTs Text for 3 other languages: language A: demo 1, language B: empty, language C: demo 2' mod='basmartseoalttags'}<br />
				{l s='If this setting is Yes, Only ALT Text of language B will be replaced to new Text because it is empty.' mod='basmartseoalttags'}
				</div>
			</div>
		</div>
		<div class="panel-footer">
			<a href="{$link_module|escape:'htmlall':'UTF-8'}&batask=general" class="btn btn-default"><i class="process-icon-cancel"></i> {l s='Cancel' mod='basmartseoalttags'}</a>
			<button type="submit" name="save" class="btn btn-default pull-right"><i class="process-icon-save"></i> {l s='Save' mod='basmartseoalttags'}</button>
			<button type="submit" name="saveandregenerate" class="btn btn-default pull-right"><i class="process-icon-save"></i> {l s='Save and Regenerate' mod='basmartseoalttags'}</button>
		</div>
	</div>
</div>