<?php
/**
* 2007-2016 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    LD
*  @copyright 2015 LD
*  @version   1.0.0
*  @link      http://www.ld.com.br/
*  @license
*
*  Based on the following version
* 
*  @author    DJTAL
*  @copyright 2017 DJTAL
*  @version   1.0.0
*  @link      http://www.djtal.com.br/
*/

class LDbrazilianregisterFiscalInformationModuleFrontController extends ModuleFrontController
{
	
	public $popup_mode = false;
	public $customer_permissions = 'none';
	//public $php_self = 'ldbrazilianregister-fiscal-information';
    
    public function __construct() {
        parent::__construct();
		
		if(Tools::isSubmit('popup_mode')){
			$this->popup_mode = true;
			//$this->display_header = false;
			//$this->display_header_javascript = false;
			//$this->display_footer = false;
		}
		
		$this->customer_permissions = Configuration::get('LDBR_CUTOMER_PERMISSIONS');
		
        if (Configuration::get('PS_SSL_ENABLED') && array_key_exists('HTTPS', $_SERVER)){
            $this->ssl = true;
		}
    }
	
	public function setMedia()
    {
		parent::setMedia();
		$this->addCSS($this->module->getPath().'/views/css/front-my-account.css');
		$this->addJS($this->module->getPath().'/views/js/jquery.mask.mod.js');
		$this->addJS($this->module->getPath().'/views/js/cpf-cnpj-my-account.js');
	}
	
	public function getBreadcrumbLinks()
    {
        $breadcrumb = parent::getBreadcrumbLinks();

        $breadcrumb['links'][] = $this->addMyAccountToBreadcrumb();

        return $breadcrumb;
    }
     
    public function displayAjax(){
		if ($this->module->active == false) {
            die('This module is not active');
		}
		$ret = $this->saveFiscalInformationPopup();
		if($ret === true){
			echo 'ok';
		}else{
			echo json_encode($ret);
		}
		die;
	}
	
    public function postProcess()
	{
        if ($this->module->active == false) {
            die('This module is not active');
		}
		
		if(Tools::isSubmit('submitFiscalInformation')) {
			$this->saveFiscalInformation();
		}
		
		$breg = BrazilianRegister::getByCustomerId($this->context->customer->id);
        $br_document_cpf = $breg['cpf'];
        $br_document_cnpj = $breg['cnpj'];
        $br_document_passport = $breg['passport'];
        $br_document_rg = $breg['rg'];
        $br_document_ie = $breg['ie'];
		$br_document_comp = $breg['comp'];
		
		$cpf_cnpj_mode = Configuration::get('LDBR_CPF_CNPJ_MODE');
		
		$br_show_comp = false;
		if((bool)Configuration::get('LDBR_ASK_COMP') == true){
			$br_show_comp = true;
		}
		
		$br_show_passport = false;
		if($cpf_cnpj_mode == 'cpf-or-cnpj-or-passport'){
			$br_show_passport = true;
		}
		
		$br_show_ie = false;
		if(((bool)Configuration::get('LDBR_CPF_CNPJ_IE') == true) && ($cpf_cnpj_mode == 'cpf-or-cnpj-or-passport' || $cpf_cnpj_mode == 'cpf-and-cnpj' || $cpf_cnpj_mode == 'cpf-or-cnpj' || $cpf_cnpj_mode == 'cnpj-only')){
			$br_show_ie = true;
		}
		
		$br_show_rg = false;
		if(((bool)Configuration::get('LDBR_CPF_CNPJ_RG') == true) && ($cpf_cnpj_mode == 'cpf-or-cnpj-or-passport' || $cpf_cnpj_mode == 'cpf-and-cnpj' || $cpf_cnpj_mode == 'cpf-or-cnpj' || $cpf_cnpj_mode == 'cpf-only')){
			$br_show_rg = true;
		}
		
		$br_show_cpf = false;
		if($cpf_cnpj_mode == 'cpf-or-cnpj-or-passport' || $cpf_cnpj_mode == 'cpf-and-cnpj' || $cpf_cnpj_mode == 'cpf-or-cnpj' || $cpf_cnpj_mode == 'cpf-only'){
			$br_show_cpf = true;
		}
		
		$br_show_cnpj = false;
		if($cpf_cnpj_mode == 'cpf-or-cnpj-or-passport' || $cpf_cnpj_mode == 'cpf-and-cnpj' || $cpf_cnpj_mode == 'cpf-or-cnpj' || $cpf_cnpj_mode == 'cnpj-only'){
			$br_show_cnpj = true;
		}
		
		$br_show_or_option = false;
		if($cpf_cnpj_mode == 'cpf-or-cnpj-or-passport' || $cpf_cnpj_mode == 'cpf-or-cnpj'){
			$br_show_or_option = true;
		}
        
		
		$this->context->smarty->assign(array(	
			'customer_permissions' => $this->customer_permissions,
			'br_document_cpf' => $br_document_cpf,
			'br_document_cnpj' => $br_document_cnpj,
			'br_document_passport' => $br_document_passport,
			'br_document_rg' => $br_document_rg,
			'br_document_ie' => $br_document_ie,
			'br_document_comp' => $br_document_comp,
			'br_show_comp' => $br_show_comp,
			'br_show_passport' => $br_show_passport,
			'br_show_ie' => $br_show_ie,
			'br_show_rg' => $br_show_rg,
			'br_show_cpf' => $br_show_cpf,
			'br_show_cnpj' => $br_show_cnpj,
			'br_show_or_option' => $br_show_or_option,
		));
		if($this->popup_mode){
			return $this->setTemplate('module:ldbrazilianregister/views/templates/front/fiscal-information-popup.tpl');
		}else{
			return $this->setTemplate('module:ldbrazilianregister/views/templates/front/fiscal-information.tpl');
		}
    }
	
	public function saveFiscalInformationPopup(){
		$errors_ajax = array();
		
		$register_form = null;
		$ldbrazilianregister = BrazilianRegister::getByCustomerId((int)$this->context->customer->id);
		if($ldbrazilianregister != null){
			$register_form = new BrazilianRegister($ldbrazilianregister['id_ldbrazilianregister']);
		}else{
			$register_form = new BrazilianRegister();
			$register_form->id_customer = (int)$this->context->customer->id;
		}

		$cpf = Tools::getValue('cpf');
		$cnpj = Tools::getValue('cnpj');
		$passport = Tools::getValue('passport');
		$rg = Tools::getValue('rg');
		$ie = Tools::getValue('ie');
		$comp = Tools::getValue('comp');
		
		if(!empty($cpf)){
			if(LDbrazilianregister::validateCPF($cpf) !== false){
				$cpf = preg_replace('/[^0-9]/', '', $cpf);
				$register_form->cpf = pSQL($cpf);
			}else{
				$errors_ajax[] = $this->l('CPF').' '.$this->l('invalid');
			}
		}
		if(!empty($cnpj)){
			if(LDbrazilianregister::validateCNPJ($cnpj) !== false){
				$cnpj = preg_replace('/[^0-9]/', '', $cnpj);
				$register_form->cnpj = pSQL($cnpj);
			}else{
				$errors_ajax[] = $this->l('CNPJ').' '.$this->l('invalid');
			}
		}
		
		if(!empty($passport)){
			$register_form->passport = pSQL($passport);
		}
		if(!empty($rg)){
			$register_form->rg = pSQL($rg);
		}
		if(!empty($ie)){
			$register_form->ie = pSQL($ie);
		}
		if(!empty($comp)){
			$register_form->comp = pSQL($comp);
		}
		if(count($errors_ajax) > 0){
			return $errors_ajax;
		}
		if($register_form->save()){
			return true;
		}
	}
	
	public function saveFiscalInformation()
    {
		if($this->customer_permissions == 'none'){
			$this->errors[] = $this->l('You cannot edit or add any information');
			return false;
		}
		
		$register_form = null;
		$ldbrazilianregister = BrazilianRegister::getByCustomerId((int)$this->context->customer->id);
		if($ldbrazilianregister != null){
			$register_form = new BrazilianRegister($ldbrazilianregister['id_ldbrazilianregister']);
		}else{
			$register_form = new BrazilianRegister();
			$register_form->id_customer = (int)$this->context->customer->id;
		}
		

		$cpf = Tools::getValue('br_document_cpf');
		$cnpj = Tools::getValue('br_document_cnpj');
		$passport = Tools::getValue('br_document_passport');
		$rg = Tools::getValue('br_document_rg');
		$ie = Tools::getValue('br_document_ie');
		$comp = Tools::getValue('br_document_comp');
		
		if(!empty($cpf) && (($this->customer_permissions == 'add' && empty($register_form->cpf)) || $this->customer_permissions == 'edit')){
			if(LDbrazilianregister::validateCPF($cpf) !== false){
				$cpf = preg_replace('/[^0-9]/', '', $cpf);
				$register_form->cpf = pSQL($cpf);
			}else{
				$this->errors[] = '<b>'.$this->l('CPF').'</b> '.$this->l('is invalid');
			}
		}
		if(!empty($cnpj) && (($this->customer_permissions == 'add' && empty($register_form->cnpj)) || $this->customer_permissions == 'edit')){
			if(LDbrazilianregister::validateCNPJ($cnpj) !== false){
				$cnpj = preg_replace('/[^0-9]/', '', $cnpj);
				$register_form->cnpj = pSQL($cnpj);
			}else{
				$this->errors[] = '<b>'.$this->l('CNPJ').'</b> '.$this->l('is invalid');
			}
		}
		
		if(!empty($passport) && (($this->customer_permissions == 'add' && empty($register_form->passport)) || $this->customer_permissions == 'edit')){
			$register_form->passport = pSQL($passport);
		}
		
		if(!empty($rg) && (($this->customer_permissions == 'add' && empty($register_form->rg)) || $this->customer_permissions == 'edit')){
			$register_form->rg = pSQL($rg);
		}
		
		if(!empty($ie) && (($this->customer_permissions == 'add' && empty($register_form->ie)) || $this->customer_permissions == 'edit')){
			$register_form->ie = pSQL($ie);
		}
		
		if(!empty($comp) && (($this->customer_permissions == 'add' && empty($register_form->comp)) || $this->customer_permissions == 'edit')){
			$register_form->comp = pSQL($comp);
		}
		
		if(count($this->errors) > 0){
			return false;
		}
		
		if($register_form->save()){
			$this->context->smarty->assign(	'confirmation', true);
		}
	}
}










