<?php


if (!defined('_PS_VERSION_')) {
    exit;
}

class ldwhatsapp extends Module
{
    protected $config_form = false;
    

    public function __construct()
    {
        $this->name = 'ldwhatsapp';
        $this->tab = 'administration';
        $this->version = '1.2.0';
        $this->author = 'LD';
        $this->need_instance = 0;

        /**
         * Set $this->bootstrap to true if your module is compliant with bootstrap (PrestaShop 1.6)
         */
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Whatsapp Chat');
        $this->description = $this->l('Adicionar botão para entrar em contato através do Whatsapp');

        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
    }

    /**
     * Don't forget to create update methods if needed:
     * http://doc.prestashop.com/display/PS16/Enabling+the+Auto-Update
     */
    public function install()
    {
        include(dirname(__FILE__).'/sql/install.php');
		return parent::install() &&
            $this->registerHook('header') &&
            $this->registerHook('backOfficeHeader') &&
            $this->registerHook('displayFooter') &&
            $this->registerHook('leftColumn') &&
            $this->registerHook('rightColumn');
    }

    public function uninstall()
    {
        include(dirname(__FILE__).'/sql/uninstall.php');
		return parent::uninstall();
    }

    /**
     * Load the configuration form
     */
    public function getContent()
    {
		$add = 0;
		if (((bool)Tools::isSubmit('cmdSave')) == true) {
            $serial = Tools::getValue('serial');
			$phone = Tools::getValue('phone');
			$shook = Tools::getValue('shook');
			$shareThis = Tools::getValue('shareThis');
			$shareMessage = Tools::getValue('shareMessage');
            $local = Tools::getValue('local');
            $color = Tools::getValue('color');
            $sheight = Tools::getValue('sheight');
		
			if( Validate::isPhoneNumber($phone) && Validate::isCountryName($shook) && Validate::isInt($shareThis) && Validate::isCleanHtml($shareMessage))
			{
				Db::getInstance()->update('ldwhatsapp', array(
                    'serial'		=> pSQL($serial),
					'phone' 		=> pSQL($phone),
					'shareThis' 	=> (int)$shareThis,
					'shareMessage' 	=> pSQL($shareMessage),
					'hook' 			=> pSQL($shook),
                    'local'			=> pSQL($local),
                    'color'			=> pSQL($color),
                    'sheight'			=> pSQL($sheight),
				), 'id_whatsapp = 1');
				$add = 1;
			}
		}
		$iso_code = $this->context->language->iso_code;
		$no = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'ldwhatsapp WHERE id_whatsapp = 1');
        $serial     		= $no['serial'];
		$whatasppno 		= $no['phone'];
		$hook 				= $no['hook'];
		$shareThis 			= $no['shareThis'];
		$shareMessage  		= $no['shareMessage'];
        $local  		    = $no['local'];
        $color      		= $no['color'];
        $sheight      		= $no['sheight'];
		
		$this->context->smarty->assign(array(
            'serial' 	=> $serial,
			'whatasppno' 	=> $whatasppno,
			'hook' 			=> $hook,
			'shareThis' 	=> $shareThis,
			'shareMessage' 	=> $shareMessage,
			'whp_mdir' 		=> $this->_path,
			'lang_iso' 		=> $iso_code,
			'pyazi' 		=> "{PRODUCT}",
            'local' 	    => $local,
            'color'     	=> $color,
            'sheight'     	=> $sheight,
			'add' 			=> $add,
		));
        return $this->context->smarty->fetch($this->local_path.'views/templates/admin/configure.tpl');

    }

    /**
    * Add the CSS & JavaScript files you want to be loaded in the BO.
    */
    public function hookBackOfficeHeader()
    {
        if (Tools::getValue('module_name') == $this->name) {
            $this->context->controller->addJS($this->_path.'views/js/back.js');
            $this->context->controller->addCSS($this->_path.'views/css/back.css');
        }
    }

    /**
     * Add the CSS & JavaScript files you want to be added on the FO.
     */
    public function hookHeader()
    {
        $this->context->controller->addJS($this->_path.'/views/js/whatsapp.js');
        $this->context->controller->addCSS($this->_path.'/views/css/whatsapp.css');
    }

    public function whatsapp($params)
    {
		$detect = new Mobile_Detect;
		$deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
		
		$no = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'ldwhatsapp WHERE id_whatsapp = 1');
        $serial 		= $no['serial'];
		$whatasppno 		= $no['phone'];
		$hook 				= $no['hook'];
		$shareThis 			= $no['shareThis'];
		$shareMessage  		= $no['shareMessage'];
        $local        		= $no['local'];
        $color        		= $no['color'];
        $sheight       		= $no['sheight'];
        $coreSerial = $serial;
        $coreBASE = _PS_BASE_URL_;
        include 'CorePresta.php';		
		$page = Tools::getValue('controller');
		if (Validate::isCountryName($page) && $page == 'product')
		{
			$idPr = (int)Tools::getValue('id_product');
			$lang = (int)$params['cookie']->id_lang;
			$pr   = Db::getInstance()->getRow('SELECT * FROM `'._DB_PREFIX_.'product_lang` WHERE id_product = '.$idPr.' AND id_lang = '.$lang.'');
			$name = $pr['name'];
			
			$shareMessage = str_replace("{PRODUCT}","*".$name."*","{$shareMessage}");
		}
		
		$this->context->smarty->assign(array(
			'whatasppno' 	=> $whatasppno,
			'hook' 		 	=> $hook,
			'deviceType' 	=> $deviceType,
			'shareThis' 	=> $shareThis,
			'shareMessage' 	=> $shareMessage,
            'local' 	    => $local,
            'color'      	=> $color,
            'sheight'      	=> $sheight,
			'whataspp_module_dir' => $this->_path,
		));
			return $this->context->smarty->fetch($this->local_path.'views/templates/front/footer.tpl');
    }
	public function hookDisplayFooter($params)
    {
        $no = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'ldwhatsapp WHERE id_whatsapp = 1');
		$hook = $no['hook'];
		if ($hook == 'footer')
			return $this->whatsapp($params);
    }
	public function hookLeftColumn($params)
	{
		$no = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'ldwhatsapp WHERE id_whatsapp = 1');
		$hook = $no['hook'];
		if ($hook == 'leftColumn')
			return $this->whatsapp($params);
	}
	public function hookRightColumn($params)
	{
		$no = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'ldwhatsapp WHERE id_whatsapp = 1');
		$hook = $no['hook'];
		if ($hook == 'rightColumn')
			return $this->whatsapp($params);
	}
}
