<?php
/**
* 2013-2018 Ovidiu Cimpean
*
* Ovidiu Cimpean - Newsletter Pro © All rights reserved.
*
* DISCLAIMER
*
* Do not edit, modify or copy this file.
* If you wish to customize it, contact us at addons4prestashop@gmail.com.
*
* @author    Ovidiu Cimpean <addons4prestashop@gmail.com>
* @copyright 2013-2018 Ovidiu Cimpean
* @license   Do not edit, modify or copy this file
* @version   Release: 4
*/

class NewsletterProConfiguration
{
    public static function get($path = null)
    {
        $data = NewsletterPro::getInstance()->configuration;

        if (!isset($path)) {
            return $data;
        }

        $parts = explode('.', $path);
        $part_data = null;

        if (count($parts) > 1) {
            foreach ($parts as $part) {
                if (!isset($part_data)) {
                    $part_data = $data;
                }
                if (!array_key_exists($part, $part_data)) {
                    throw new sprintf(Exception('The module configuration [%s] does not exists into the database.', $path));
                }
                $part_data = $part_data[$part];
            }
            return $part_data;
        } else {
            if (!array_key_exists($path, $data)) {
                throw new sprintf(Exception('The module configuration [%s] does not exists into the database.', $path));
            }
            return $data[$path];
        }
    }

    public static function set($path, $value, $write = false)
    {
        $data =& NewsletterPro::getInstance()->configuration;

        $parts = explode('.', $path);

        $part_data = null;
        $count_parts = count($parts);

        if ($count_parts > 0) {
            foreach ($parts as $index => $part) {

                if (!isset($part_data)) {
                    $part_data =& $data;
                }
                
                if (!$write && !array_key_exists($part, $part_data)) {
                    throw new Exception(sprintf('The module configuration [%s] does not exists into the database to be able to set it.', $path));
                }

                if ($index < $count_parts - 1) {
                    $part_data =& $part_data[$part];
                }
            }
            $part_data[$part] = $value;
        } else {
            if (!$write && !array_key_exists($path, $data)) {
                throw new Exception(sprintf('The module configuration [%s] does not exists into the database to be able to set it.', $path));
            }

            $data[$path] = $value;
        }

        if (!Configuration::updateValue('NEWSLETTER_PRO', serialize($data), false, 0, 0)) {
            throw new Exception(sprintf('Unable to write the configuration [%s] into database.', $path));
        }
    }

    public static function delete($name)
    {
        $data = &NewsletterPro::getInstance()->configuration;

        if (array_key_exists($name, $data)) {
            unset($data[$name]);
        }

        if (!Configuration::updateValue('NEWSLETTER_PRO', serialize($data), false, 0, 0)) {
            throw new Exception(sprintf('Unable to write the configuration [%s] into database.', $name));
        }
    }

    public static function config($path = null, $value = null, $write = false)
    {
        if (isset($value)) {
            return self::set($path, $value, $write);
        }

        return self::get($path);
    }
}
