<?php
/**
* 2013-2018 Ovidiu Cimpean
*
* Ovidiu Cimpean - Newsletter Pro © All rights reserved.
*
* DISCLAIMER
*
* Do not edit, modify or copy this file.
* If you wish to customize it, contact us at addons4prestashop@gmail.com.
*
* @author    Ovidiu Cimpean <addons4prestashop@gmail.com>
* @copyright 2013-2018 Ovidiu Cimpean
* @license   Do not edit, modify or copy this file
* @version   Release: 4
*/

abstract class NewsletterProListManager
{
    const TABLE_ALL = 0x0F;

    const TABLE_CUSTOMER = 0x01;

    const TABLE_NEWSLETTER = 0x02;

    const TABLE_EMAIL = 0x04;

    const TABLE_SUBSCRIBER = 0x08;

    public static $tables = array(
        'emailsubscription' => array(
            'flag' => self::TABLE_NEWSLETTER,
            'fields' => array(
                'email' => 'email',
                'active' => 'active',
            )
        ),
        'newsletter' => array(
            'flag' => self::TABLE_NEWSLETTER,
            'fields' => array(
                'email' => 'email',
                'active' => 'active',
            )
        ),
        'newsletter_pro_subscribers' => array(
            'flag' => self::TABLE_SUBSCRIBER,
            'fields' => array(
                'email' => 'email',
                'active' => 'active',
            )
        ),
        'newsletter_pro_email' => array(
            'flag' => self::TABLE_EMAIL,
            'fields' => array(
                'email' => 'email',
                'active' => 'active',
            )
        ),
        'customer' => array(
            'flag' => self::TABLE_CUSTOMER,
            'fields' => array(
                'email' => 'email',
                'active' => 'newsletter',
            )
        )
    );

    public static function parse($callback, $flags = null)
    {
        if (!isset($flags)) {
            $flags = self::TABLE_ALL;
        }

        $data = array();
        foreach (self::$tables as $table_name => $info) {
            if (NewsletterProTools::tableExists($table_name) && ($flags & $info['flag']) > 0) {
                $data[$table_name] = $callback($table_name, array(
                    'email' => $info['fields']['email'],
                    'active' => $info['fields']['active'],
                ));
            }
        }
        return $data;
    } 
}
