<?php
/**
* 2013-2018 Ovidiu Cimpean
*
* Ovidiu Cimpean - Newsletter Pro © All rights reserved.
*
* DISCLAIMER
*
* Do not edit, modify or copy this file.
* If you wish to customize it, contact us at addons4prestashop@gmail.com.
*
* @author    Ovidiu Cimpean <addons4prestashop@gmail.com>
* @copyright 2013-2018 Ovidiu Cimpean
* @license   Do not edit, modify or copy this file
* @version   Release: 4
*/

class NewsletterProTerminalCommandHelp extends NewsletterProTerminalCommand implements NewsletterProTerminalCommandInterface
{
	public function help(&$output)
	{
		$this->out($this->outCommand('help').' [options...] '.$this->outDescription('- Display available commands.'), 0, false);
		$this->out($this->outOption('help').'      '.$this->outDescription('- List of the help commands.'), 1, false);
		$this->out($this->outOption('clear').'     '.$this->outDescription('- Clear the console.'), 1, false);
		$this->out($this->outOption('shortcuts').' '.$this->outDescription('- List of terminal shortcuts.'), 1, false);
		$this->out($this->outOption('send').'      '.$this->outDescription('- List of the send commands.'), 1, false);
		$this->out($this->outOption('config').'    '.$this->outDescription('- List of the config commands.')."\n", 1, false);

    	foreach ($this->output as $line)
    		$output[] = $line;
	}

	public function run()
	{
    	if (!$this->hasFlags())
    	{
    		$this->out('List of all the commands available:'."\n");
	    	$this->helpShrtcuts();
	    	NewsletterProTerminalCommandHelp::newInstance()->help($this->output);
	    	$this->helpClear();
	    	NewsletterProTerminalCommandConfig::newInstance()->help($this->output);
	    	NewsletterProTerminalCommandSend::newInstance()->help($this->output);
    	}
    	else if ($this->hasFlag('help'))
    		NewsletterProTerminalCommandHelp::newInstance()->help($this->output);
    	else if ($this->hasFlag('shortcuts'))
    		$this->helpShrtcuts();
    	else if ($this->hasFlag('clear'))
    		$this->helpClear();
    	else if ($this->hasFlag('config'))
			NewsletterProTerminalCommandConfig::newInstance()->help($this->output);
    	else if ($this->hasFlag('send'))
    		NewsletterProTerminalCommandSend::newInstance()->help($this->output);
    	else
    		throw self::throwError(self::ERROR_INVALID_OPTION);
	}

    private function helpShrtcuts()
    {
		$this->out('Terminal shortcuts:'."\n");
		$this->out('up        '.$this->outDescription('- Go to the last command if the input buffer is empty.'), 0, false);
		$this->out('ctrl+up   '.$this->outDescription('- Go to the previous command.'), 0, false);
		$this->out('ctrl+down '.$this->outDescription('- Go to the next command.') . "\n", 0, false);
    }

    private function helpClear()
    {
		$this->out($this->outCommand('clear').' '.$this->outDescription('- Clear the console.')."\n", 0, false);
    }
}
