<?php
/**
* 2013-2018 Ovidiu Cimpean
*
* Ovidiu Cimpean - Newsletter Pro © All rights reserved.
*
* DISCLAIMER
*
* Do not edit, modify or copy this file.
* If you wish to customize it, contact us at addons4prestashop@gmail.com.
*
* @author    Ovidiu Cimpean <addons4prestashop@gmail.com>
* @copyright 2013-2018 Ovidiu Cimpean
* @license   Do not edit, modify or copy this file
* @version   Release: 4
*/

class NewsletterProAjaxModuleFrontController extends ModuleFrontController {
    public $auth = false;

    public $ssl = false;

    private $response;

    private $request;

    public function __construct()
    {
        if ((bool)Configuration::get('PS_SSL_ENABLED')) {
            $this->ssl = true;
        }
        
        parent::__construct();

        $this->response = new NewsletterProResponse();
        $this->request = new NewsletterProRequest();
    }

    public function setMedia()
    {
        parent::setMedia();
    }

    public function postProcess()
    {
        parent::postProcess();

        if ($this->request->has('pqnpAction')) {
            $action = $this->request->get('pqnpAction');

            switch ($action) {
                case 'popup':
                    return NewsletterProPopupAction::newInstance()->call($this->request->get('target'));
            }
        }


        die('Invalid Action');
    }


}
