<?php

namespace Spatie\Regex;

class Regex
{
    /**
     * @param string $pattern
     * @param string $subject
     *
     * @return \Spatie\Regex\MatchResult
     */
    public static function match($pattern, $subject)
    {
        return MatchResult::forPsb($pattern, $subject);
    }

    /**
     * @param string $pattern
     * @param string $subject
     *
     * @return \Spatie\Regex\MatchAllResult
     */
    public static function matchAll($pattern, $subject)
    {
        return MatchAllResult::forPsb($pattern, $subject);
    }

    /**
     * @param string|array $pattern
     * @param string|array|callable $replacement
     * @param string|array $subject
     * @param int $limit
     *
     * @return \Spatie\Regex\ReplaceResult
     */
    public static function replace($pattern, $replacement, $subject, $limit = -1)
    {
        return ReplaceResult::forPsb($pattern, $replacement, $subject, $limit);
    }
}
