{*
* 2019 PSBlog
*
* NOTICE OF LICENSE
*
* READ ATTACHED LICENSE.TXT
*
*  @author    PSBlog
*  @copyright 2019 PSBlog
*  @license   LICENSE.TXT
*}

<script>
    $(document).ready(function () {
        // Search Backups at LOAD
        $('#restore_backup').children('i').removeClass('icon-save').addClass('icon-spinner icon-spin');
        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: '{$index_url|escape:'html':'UTF-8'}',
            data: {
                ajax: true,
                action: 'listbackup',
                controller: 'ajxpetitions',
                module: 'prestarcards',
                fc: 'module',
                security: '{$security|escape:'html':'UTF-8'}'
            }
        })
        .done(function(json_response) {
            $('#restore_backup').children('i').removeClass('icon-spinner icon-spin').addClass('icon-save');
            var lines = '';
            var affected_files = 0;
            // For theme
            $.each(json_response.theme, function(i, item) {
                lines += item+"\n";
                affected_files++;
            });
            // For module
            $.each(json_response.modules, function(i, item) {
                lines += item+"\n";
                affected_files++;
            });
            // If backed up files, list them
            if (affected_files > 0)
            {  
                $('#affected_backup').removeClass('hidden');
                $('#result_backups').focus().text(lines);
                $('#restore_backup').prop('disabled', false);
            }
        })
        .fail(function() {
        });

        // Restore Backups
        $('#restore_backup').on('click', function () {
            var button_restore = $(this);
            $(this).prop('disabled', true);
            $(this).children('i').removeClass('icon-eraser').addClass('icon-spinner icon-spin');
            
            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: '{$index_url|escape:'html':'UTF-8'}',
                data: {
                    ajax: true,
                    action: 'restorebackup',
                    controller: 'ajxpetitions',
                    module: 'prestarcards',
                    fc: 'module',
                    security: '{$security|escape:'html':'UTF-8'}'
                }
            })
            .done(function(json_response) {
                var lines = '';
                var affected_files = 0;
                $.each(json_response, function(i, item) {
                    lines += item+"\n";
                    affected_files++;
                });
                // If restored files, list them
                if (affected_files > 0)
                {
                    lines = lines + "\n" + '{l s='RESTORED ABOVE FILES SUCCESFULLY :)' mod='prestarcards'}';
                    $('#result_backups').focus().text(lines);
                    $('#affected_backup').removeClass('hidden');
                    $('#restore_backup').prop('disabled', false);
                }
                $(button_restore).children('i').addClass('icon-eraser').removeClass('icon-spinner icon-spin');
                $(button_restore).prop('disabled', false);
                
            })
            .fail(function() {
            });
        });
    
        // Backup and Remove the snippets
        $('#clearsnippets_btn').on('click', function () {
            var button_clean = $(this);
            var removemodules = $('#removeModules').attr('checked') ? true : false;

            $(this).prop('disabled', true);
            $(this).children('i').removeClass('icon-eraser').addClass('icon-spinner icon-spin');
            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: '{$index_url|escape:'html':'UTF-8'}',
                data: {
                    ajax: true,
                    action: 'backupsnippets',
                    controller: 'ajxpetitions',
                    module: 'prestarcards',
                    fc: 'module',
                    security: '{$security|escape:'html':'UTF-8'}'
                }
            })
            .done(function(json_response) {
                var lines = '';
                var affected_files = 0;
                $.each(json_response, function(i, item) {
                    lines += item+"\n";
                    affected_files++;
                });
                
                if (affected_files > 0)
                {
                    lines = '{l s='Created backup for:' mod='prestarcards'}' + '\n' + lines;
                    $('#result').focus().text(lines);
                    // Go for the removal
                    $.ajax({
                        type: 'POST',
                        dataType: 'json',
                        url: '{$index_url|escape:'html':'UTF-8'}',
                        data: {
                            ajax: true,
                            removemodules: removemodules,
                            action: 'cleansnippets',
                            controller: 'ajxpetitions',
                            module: 'prestarcards',
                            fc: 'module',
                            security: '{$security|escape:'html':'UTF-8'}'
                        }
                    })
                    .done(function(json_response_clean) {
                        lines = '{l s='Removed snippets from theme/modules. Clear you cache and check if everything is showing OK.' mod='prestarcards'}' + '\n' + lines;
                        $('#result, #result_modules').focus().text(lines);
                    })
                    .fail(function() {
                    });                    
                }
                
                $(button_clean).children('i').addClass('icon-eraser').removeClass('icon-spinner icon-spin');
                $(button_clean).prop('disabled', false);
            })
            .fail(function() {
                $(button_clean).prop('disabled', false);
                $(button_clean).children('i').addClass('icon-eraser').removeClass('icon-spinner icon-spin');
            });
        });
        
        // Search Button
        $('#btn_search_tpls').on('click', function () {
            $('#affected_theme, #affected_modules').addClass('hidden');
            var button_search = $(this);
            $(this).prop('disabled', true);
            $(this).children('i').removeClass('icon-search').addClass('icon-spinner icon-spin');
            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: '{$index_url|escape:'html':'UTF-8'}',
                data: {
                    ajax: true,
                    action: 'allsnippets',
                    controller: 'ajxpetitions',
                    module: 'prestarcards',
                    fc: 'module',
                    security: '{$security|escape:'html':'UTF-8'}'
                }
            })
            .done(function(json_response) {
                var lines = '';
                var affected_files = 0;
                var affected_files_theme = 0;
                var affected_files_mod = 0;
                $.each(json_response.theme, function(i, item) {
                    lines += item+"\n";
                    affected_files_theme++;
                });
                // THEME FILES
                $('#result').text(lines);
                if (affected_files_theme > 0) $('#affected_theme').removeClass('hidden');
                // MODULE FILES
                var lines = '';
                $.each(json_response.modules, function(i, item) {
                    lines += item+"\n";
                    affected_files_mod++;
                });
                // THEME FILES
                $('#result_modules').focus().text(lines);
                if (affected_files_mod > 0) $('#affected_modules').removeClass('hidden');
                
                // If none are found
                if (affected_files_theme == 0 && affected_files_mod == 0)
                {
                    lines = '{l s='None of your files contains rich snippets.' mod='prestarcards'}';
                    $('#result').focus().text(lines);
                    $('#affected_theme').removeClass('hidden');
                }
                
                $(button_search).prop('disabled', false);
                $(button_search).children('i').addClass('icon-search').removeClass('icon-spinner icon-spin');
                affected_files = affected_files_theme + affected_files_mod;
                if (affected_files > 0)
                {
                    $('#clearsnippets_btn, #removeModules').prop('disabled', false);
                } else {
                    $('#clearsnippets_btn, #removeModules').prop('disabled', true);
                }
            })
            .fail(function() {
                $(button_search).prop('disabled', false);
                $(button_search).children('i').addClass('icon-search').removeClass('icon-spinner icon-spin');
            });
        }); 
    });
</script>