{*
* 2017-2019 PSBlog
*
* NOTICE OF LICENSE
*
* READ ATTACHED LICENSE.TXT
*
*  @author    PSBlog
*  @copyright 2017-2019 PSBlog
*  @license   LICENSE.TXT
*}

{include file='./scripts.tpl'}

<div class="row">

    <div class="col-md-5">
        <span class="label label-primary">{l s='Current Theme' mod='prestarcards'}</span>
        <input type="text" readonly="readonly" value="{$theme_folder|escape:'htmlall':'UTF-8'}">
    </div>
    
    <div class="col-md-5">
        <span class="label label-primary">{l s='Current Modules' mod='prestarcards'}</span>
        <input type="text" readonly="readonly" value="{$modules_folder|escape:'htmlall':'UTF-8'}">
    </div>

    <div class="col-md-2">
        <br/>
        <button type="button" id="btn_search_tpls" name="send_btn" class="btn pull-righ btn-primary btn-block">
            {l s='SEARCH FOR SNIPPETS' mod='prestarcards'}&nbsp;<i class="icon-search"></i>
        </button>								
    </div>
</div>						

        
<br/>

<div class="controls hidden" id="affected_theme">
    <span class="label label-primary">{l s='Affected THEME files:' mod='prestarcards'}</span>
    <textarea readonly id="result" name="result" rows="12"></textarea>
    <br />
</div>

<div class="controls hidden" id="affected_modules">
    <span class="label label-primary">{l s='Affected MODULE files:' mod='prestarcards'}</span>
    <textarea readonly id="result_modules" name="result_modules" rows="12"></textarea>
    <br />
</div>
    
<div class="controls hidden" id="affected_backup">
    <span class="label label-danger">{l s='Backup THEME/MODULE files:' mod='prestarcards'}</span>
    <textarea readonly id="result_backups" name="result_backups" rows="12"></textarea>
    <br />
</div>
        
<div class="row">
    <div class="alert alert-danger" role="alert">
        <strong>{l s='Read Carefuly' mod='prestarcards'}:</strong> {l s='This option will search automatically all your rich snippets from your theme and will remove them, making a backup first. This option can break your site, so use it at your own risk. If you find in trouble just restore your backup files and clean your cache, should be enough to make it work again.' mod='prestarcards'}
    </div>    

    <div class="col-md-12">
        <div class="checkbox">
            <label><input type="checkbox" value="" id="removeModules" disabled>{l s='Remove modules snippets too' mod='prestarcards'}</label>
        </div>        
    </div>
</div>

<div class="row">
    <div class="col-md-2">
        <button type="button" id="restore_backup" name="restore_backup" class="btn pull-righ btn-block btn" disabled="disabled">
            <i class="icon-save"></i>&nbsp;{l s='Restore Backup' mod='prestarcards'}
        </button>
    </div>

    <div class="col-md-4">
        <button type="button" id="clearsnippets_btn" name="clear_btn" class="btn pull-righ btn-block btn-success" disabled="disabled">
            <i class="icon-eraser"></i>&nbsp;{l s='Make a backup and Remove Snippets' mod='prestarcards'}
        </button>
    </div>
    <div class="col-md-6">
        &nbsp;
    </div>        
    <br/>
</div>							
<br/>